PROGRAM_NAME='Newline ProSeries Demo'
(***********************************************************)
(***********************************************************)
(*  FILE_LAST_MODIFIED_ON: 04/05/2006  AT: 09:00:25        *)
(***********************************************************)
(* System Type : NetLinx                                   *)
(***********************************************************)
(* REV HISTORY:                                            *)
(***********************************************************)
(*
    $History: $
*)
(***********************************************************)
(*          DEVICE NUMBER DEFINITIONS GO BELOW             *)
(***********************************************************)
DEFINE_DEVICE
dvNx1200 = 0:1:0
dvPanel = 10001:1:0;
vdvNewline = 41001:1:0
//For IP Control
dvNewline = 0:3:0;

//For Serial Control
//dvNewline = 5001:1:0;

(***********************************************************)
(*               CONSTANT DEFINITIONS GO BELOW             *)
(***********************************************************)
DEFINE_CONSTANT

(***********************************************************)
(*              DATA TYPE DEFINITIONS GO BELOW             *)
(***********************************************************)
DEFINE_TYPE

(***********************************************************)
(*               VARIABLE DEFINITIONS GO BELOW             *)
(***********************************************************)
DEFINE_VARIABLE

(***********************************************************)
(*               LATCHING DEFINITIONS GO BELOW             *)
(***********************************************************)
DEFINE_LATCHING

(***********************************************************)
(*       MUTUALLY EXCLUSIVE DEFINITIONS GO BELOW           *)
(***********************************************************)
DEFINE_MUTUALLY_EXCLUSIVE

(***********************************************************)
(*        SUBROUTINE/FUNCTION DEFINITIONS GO BELOW         *)
(***********************************************************)
(* EXAMPLE: DEFINE_FUNCTION <RETURN_TYPE> <NAME> (<PARAMETERS>) *)
(* EXAMPLE: DEFINE_CALL '<NAME>' (<PARAMETERS>) *)

(***********************************************************)
(*                STARTUP CODE GOES BELOW                  *)
(***********************************************************)
DEFINE_START

DEFINE_MODULE 'DEMO UI Module' modDemoUI(vdvNewline, dvPanel);
DEFINE_MODULE 'Newline_ProSeries_dr1_0_0' modNewline(vdvNewline, dvNewline);
(***********************************************************)
(*                THE EVENTS GO BELOW                      *)
(***********************************************************)
DEFINE_EVENT

DATA_EVENT[vdvNewline]
{
	ONLINE:
	{
		
		WAIT 50 'vdvNewline SETTLE'
		{
			SEND_COMMAND vdvNewline,'DEBUG-4'
			
			//Only needed for IP Control
			//Test Display 1
			//SEND_COMMAND vdvNewline,'PROPERTY-MAC_Address,DC:62:94:36:24:EF'
			//SEND_COMMAND vdvNewline,'PROPERTY-IP_Address,192.168.196.216'
			
			//Test Display 2
			SEND_COMMAND vdvNewline,'PROPERTY-MAC_Address,D0:93:95:7C:D3:23'
			SEND_COMMAND vdvNewline,'PROPERTY-IP_Address,192.168.196.222'
			
			SEND_COMMAND vdvNewline,'REINIT'		
		}
	}
}

(*****************************************************************)
(*                                                               *)
(*                      !!!! WARNING !!!!                        *)
(*                                                               *)
(* Due to differences in the underlying architecture of the      *)
(* X-Series masters, changing variables in the DEFINE_PROGRAM    *)
(* section of code can negatively impact program performance.    *)
(*                                                               *)
(* See Differences in DEFINE_PROGRAM Program Execution section *)
(* of the NX-Series Controllers WebConsole & Programming Guide   *)
(* for additional and alternate coding methodologies.            *)
(*****************************************************************)

DEFINE_PROGRAM

(*****************************************************************)
(*                       END OF PROGRAM                          *)
(*                                                               *)
(*         !!!  DO NOT PUT ANY CODE BELOW THIS COMMENT  !!!      *)
(*                                                               *)
(*****************************************************************)


